
#include "MC56F8006.h"
#include "lib_utils.h"
#include "lib_sci.h"

#define USE_C1C2


void configure_A0A1_GPIO()
{
#ifndef	USE_C1C2
	/* Configure GPIO A0 as input and A1 as output for slave */
	GPIOA_DR  |= (GPIOA_DR_DR_0 | GPIOA_DR_DR_1); 
	GPIOA_DDR |= GPIOA_DDR_DDR_1;
	GPIOA_DDR &= ~(GPIOA_DDR_DDR_0);
	GPIOA_PER &= ~(GPIOA_PER_PER_0 | GPIOA_PER_PER_1);
#else
	/* Configure GPIO C1 as input and C2 as output for slave */
	GPIOC_DR  |= (GPIOC_DR_DR_1 | GPIOC_DR_DR_2); 
	GPIOC_DDR |= GPIOC_DDR_DDR_2;
	GPIOC_DDR &= ~(GPIOC_DDR_DDR_1);
	GPIOC_PER &= ~(GPIOC_PER_PER_1 | GPIOC_PER_PER_2);	
#endif	
}


void generate_pulse_A1()
{
	int16_t i;

#ifndef	USE_C1C2		
	while((GPIOA_DR & GPIOA_DR_DR_0)); /* wait master ready */
	GPIOA_DR &= ~GPIOA_DR_DR_1;			
	for(i = 0; i < 1000; i++)
	{		
	}
	GPIOA_DR |= GPIOA_DR_DR_1;	
#else
	while((GPIOC_DR & GPIOC_DR_DR_1)); /* wait master ready */
	GPIOC_DR &= ~GPIOC_DR_DR_2;			
	for(i = 0; i < 1000; i++)
	{		
	}
	GPIOC_DR |= GPIOC_DR_DR_2;		
#endif		
}


void wait_slave_ready()
{
#ifndef	USE_C1C2		
	while(!(GPIOA_DR & GPIOA_DR_DR_0)); /* wait master ready */
#else
	while(!(GPIOC_DR & GPIOC_DR_DR_1)); /* wait master ready */
#endif	
}

/*
** ===================================================================
**     Method      :  Cpu_Delay100US (bean 56F8013VFAE)
**
**     Description :
**         This method realizes software delay. The length of delay
**         is at least 100 microsecond multiply input parameter
**         [us100]. As the delay implementation is not based on real
**         clock, the delay time may be increased by interrupt
**         service routines processed during the delay. Adding read
**         wait states for external program memory can cause delay
**         extension as well. The method is independent on selected
**         speed mode.
**     Parameters  :
**         NAME            - DESCRIPTION
**         us100           - Number of 100 us delay repetitions.
**     Returns     : Nothing
** ===================================================================
*/
/*lint -save -e???? Disable MISRA rule (all) checking. */
asm void Cpu_Delay100US(int16_t us100)
{
  /* Total irremovable overhead: about 16 cycles */
  /* move.w: 2 cycles overhead (load parameter into register) */
  /* jsr:    5 cycles overhead (jump to subroutine) */
  /* rts:    8 cycles overhead (return from subroutine) */
  /* nop:    1 cycles overhead (aditional nops) */
  alignsp
  loop:
  /* 100 us delay block begin */
  /*
   * Delay
   *   - requested                  : 100 us @ 32MHz,
   *   - possible                   : 3200 c, 100000 ns
   *   - without removable overhead : 3194 c, 99812.5 ns
   */
  adda #2, SP                          /* (1 c: 31.25 ns) move SP forward */
  move.l A10, X:(SP)                   /* (2 c: 62.5 ns) push A */
  move.w #3178, A                      /* (2 c: 62.5 ns) number of iterations */
  do A, label0                         /* (8 c: 250 ns) repeat 3178x nop */
    nop                                /* (1 c: 31.25 ns) wait for 1 c */
  label0:
  move.l X:(SP), A                     /* (2 c: 62.5 ns) pop A */
  suba #2, SP                          /* (1 c: 31.25 ns) move SP back */
  /* 100 us delay block end */
  dec.w Y0                             /* us100 parameter is passed via Y0 register */
  jne loop                             /* next loop */
  nop  
  suba        #2,SP                                /* avoid pipeline conflicts */
  nop
  nop
  move.l x:(sp)-,sp
  nop
  nop
  rts                                  /* return from subroutine */
}

void read_expect(vuint16_t *pAddr, uint16_t expect)
{
	if(*pAddr != expect)
	{
		Print("Err: read value is not expected\r\n");
		Print("Addr = 0x");
		PrintDigit((uint16_t)pAddr);
		Print(", value = 0x");
		PrintDigit(*pAddr);
		Print(", expected value = 0x");
		PrintDigit(expect);
		Print("\r\n");
	}
}


void write_verify_mask(vuint16_t *addr, uint16_t data, uint16_t exp, uint16_t msk)
{
   uint16_t actual_data;
 
   *addr = data;
   actual_data = *addr;
   
   if ((actual_data & msk) != (exp & msk))
   { 
		Print("Err: write value\r\n");
		Print("Addr = 0x");
		PrintDigit((uint16_t)addr);
		Print(", value = 0x");
		PrintDigit(*addr);
		Print(", expected value = 0x");
		PrintDigit(exp);
		Print("\r\n");   
   }	
}

void write_verify(vuint16_t *addr, uint16_t data, uint16_t exp)
{
   uint16_t actual_data;
 
   *addr = data;
   actual_data = *addr;
   
   if ((actual_data) != (exp))
   { 
		Print("Err: write value\r\n");
		Print("Addr = 0x");
		PrintDigit((uint16_t)addr);
		Print(", value = 0x");
		PrintDigit(*addr);
		Print(", expected value = 0x");
		PrintDigit(exp);
		Print("\r\n");   
   }	
}


/*lint -restore */